/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.tools.Util;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.Timer;

public abstract class Icon
extends JComponent
implements MouseMotionListener,
MouseListener {
    protected String DESCRIPTION = null;
    protected boolean up = true;
    protected boolean in = false;
    protected Aladin aladin;
    protected int W;
    protected int H;
    protected int DX;
    private Timer timerTip = null;

    protected Icon(Aladin aladin, int width, int height) {
        double scale = (double)(Aladin.getUIScale() - 1.0f) / 1.25 + 1.0;
        this.W = (int)((double)width * scale);
        this.H = (int)((double)height * scale);
        this.DX = (int)Math.round((double)(this.W - width) / 2.0);
        this.aladin = aladin;
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.setBackground(Aladin.COLOR_MAINPANEL_BACKGROUND);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.W, this.H);
    }

    protected void drawLogo(Graphics g) {
        g.setColor(Aladin.COLOR_MAINPANEL_BACKGROUND);
        g.fillRect(0, 0, this.W, this.H);
    }

    protected boolean isAvailable() {
        return true;
    }

    protected boolean isActivated() {
        return false;
    }

    protected boolean isMouseIn() {
        return this.in;
    }

    protected Color getFillInColor() {
        return !this.isAvailable() ? Aladin.COLOR_MAINPANEL_BACKGROUND : Aladin.COLOR_CONTROL_FILL_IN;
    }

    protected Color getLogoColor() {
        Color c;
        boolean isAvailable = this.isAvailable();
        Color color = !isAvailable ? Aladin.COLOR_CONTROL_FOREGROUND_UNAVAILABLE : (c = this.isActivated() ? Aladin.COLOR_ICON_ACTIVATED : Aladin.COLOR_CONTROL_FOREGROUND);
        if (this.isMouseIn() && isAvailable) {
            c = c.brighter();
        }
        return c;
    }

    protected Color getLabelColor() {
        return this.isAvailable() ? Aladin.COLOR_CONTROL_FOREGROUND : Aladin.COLOR_CONTROL_FOREGROUND_UNAVAILABLE;
    }

    protected String Help() {
        return Aladin.chaine.getString(this.getHelpKey());
    }

    protected abstract void submit();

    protected abstract String getHelpTip();

    protected abstract String getHelpKey();

    protected void in() {
        this.up = true;
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.aladin.inHelp) {
            this.aladin.helpOff();
            return;
        }
        this.up = !this.up;
        this.repaint();
        this.submit();
    }

    private void showTip() {
        this.aladin.configuration.showHelpIfOk(this.getHelpKey());
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.aladin.inHelp) {
            return;
        }
        if (this.getHelpKey() != null) {
            if (this.timerTip == null) {
                this.timerTip = new Timer(6000, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Icon.this.showTip();
                    }
                });
            }
            this.timerTip.restart();
        } else if (Aladin.levelTrace >= 3) {
            System.err.println("Missing getHelpKey !!");
        }
        if (this.DESCRIPTION == null) {
            this.DESCRIPTION = this.getHelpTip();
        }
        Util.toolTip(this, this.DESCRIPTION, true);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.timerTip != null) {
            this.timerTip.stop();
            this.timerTip = null;
        }
        Aladin.makeCursor(this, 0);
        this.aladin.status.setText("");
        this.in = false;
        this.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.aladin.inHelp) {
            this.aladin.help.setText(this.Help());
            return;
        }
        Aladin.makeCursor(this, this.getMyCursor());
        this.in = true;
        this.repaint();
    }

    public int getMyCursor() {
        return 2;
    }

    @Override
    public void paintComponent(Graphics gr) {
        this.drawLogo(gr);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }
}

